% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling.R
\name{num_abbr}
\alias{num_abbr}
\title{Abbreviate or dis-abbreviate numerical values}
\usage{
num_abbr(x, n = 3, numeric = FALSE, ...)
}
\arguments{
\item{x}{Numeric vector}

\item{n}{Integer. Single numeric value, specifying number of
significant figures to show. Range 1 to 6.}

\item{numeric}{Boolean. Transform abbreviated number into numeric?}

\item{...}{Additional parameters.}
}
\value{
Vector of character or numeric values that contain converted values
}
\description{
This function converts a numeric vector's values into their
abbreviated character equivalent, i.e. 100E6 into 100M
and viceversa.
}
\examples{
num_abbr(rnorm(10) * 1e6)
num_abbr(rnorm(10) * 1e6, n = 1)
num_abbr(c("3K", "-58.3M", NA, 1), numeric = TRUE)
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{file_name}()},
\code{\link{formatHTML}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{quants}()},
\code{\link{removenacols}()},
\code{\link{replaceall}()},
\code{\link{replacefactor}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{zerovar}()}
}
\concept{Data Wrangling}
