% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecasting.R
\name{prophesize}
\alias{prophesize}
\title{Facebook's Prophet Forecast}
\usage{
prophesize(
  df,
  n_future = 60,
  country = NULL,
  trend.param = 0.05,
  logged = FALSE,
  pout = 0.03,
  project = "Prophet Forecast"
)
}
\arguments{
\item{df}{Data frame. Must contain date/time column and values column,
in that order.}

\item{n_future}{Integer. How many steps do you wish to forecast?}

\item{country}{Character. Country code for holidays.}

\item{trend.param}{Numeric. Flexibility of trend component. Default is 0.05,
and as this value becomes larger, the trend component will be more flexible.}

\item{logged}{Boolean. Convert values into logs?}

\item{pout}{Numeric. Get rid of pout \% of outliers.}

\item{project}{Character. Name of your forecast project for plot title}
}
\value{
List. Containing the forecast results, the prophet model, and a plot.
}
\description{
Prophet is Facebook's procedure for forecasting time series data
based on an additive model where non-linear trends are fit with
yearly, weekly, and daily seasonality, plus holiday effects. It
works best with time series that have strong seasonal effects and
several seasons of historical data. Prophet is robust to missing
data and shifts in the trend, and typically handles outliers well.
}
\details{
Official documentation: \url{https://github.com/facebook/prophet}
}
\seealso{
Other Forecast: 
\code{\link{forecast_arima}()}
}
\concept{Forecast}
