% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pdf_image.R
\name{get_pdf_image}
\alias{get_pdf_image}
\title{Obtain Image from a PDF Document}
\usage{
get_pdf_image(
  input,
  output = tempfile(fileext = ".jpg"),
  page = 1,
  width = 300,
  depth = 8,
  quality = 70
)
}
\arguments{
\item{input}{'character' string.
File path to PDF document.}

\item{output}{'character' string.
Location to write the JPEG image file.}

\item{page}{'integer' number.
Page number in the document.
Defaults to page 1.}

\item{width}{'integer' number.
Image width in pixels.}

\item{depth}{'integer' number.
Image color depth (either 8 or 16).
Defaults to 8.}

\item{quality}{'integer' number.
JPEG quality, a number between 0 and 100.
Defaults to 70.}
}
\value{
Returns the path to the image file.
}
\description{
Obtain an image from any PDF document.
Requires that the \pkg{pdftools} and \pkg{magick} packages are available.
}
\examples{
input <- system.file("extdata", "test.pdf", package = "inlpubs")
path <- get_pdf_image(input)

unlink(path)
}
\seealso{
\code{\link{add_content}} function to add cover images to the \pkg{inlpubs} package.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
