% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-facelayer-resample.R
\name{gridensity}
\alias{gridensity}
\title{Icosahedral grid-based density estimation}
\usage{
gridensity(x, y, out, trials = 100, FUN = mean)
}
\arguments{
\item{x}{Matrix of longitude, latitude data, \code{\link[sf:sf]{sf}} class, or \code{\link[sp:SpatialPoints]{SpatialPoints}} Point cloud.}

\item{y}{\code{\link{trigrid}} or \code{\link{hexagrid}} An icosahedral grid.}

\item{out}{\code{\link{trigrid}}, \code{\link{hexagrid}} or \code{\link[terra:rast]{SpatRaster}}output structure.}

\item{trials}{\code{numeric} value, the number of iterations.}

\item{FUN}{\code{function} The function to be applied on the iteration results.}
}
\value{
Either named numeric vector, or a \code{\link[terra:rast]{SpatRaster}} object. If FUN is set to \code{NULL}, the output will be either a \code{matrix} or \code{\link[terra:rast]{SpatRaster}}.
}
\description{
Spatial density estimation algorithm based on rotation of icosahedral grids.
}
\details{
Any points set can be binned to an icosahedral grid (i.e. number of incidences can be counted), which will be dependent on the exact positions of grid cells. Rotating the grid in 3d space will result in a different distribution of counts. This distribution can be resampled to a standard orientation structure. The size of the icosahedral grid cells act as a bandwidth parameter.

The implemented algorithm 1) takes a point cloud (\code{x})) and an icosahedral grid \code{y} 2) randomly rotates the icosahedral grid, 3) looks up the points falling on grid cells, 4) resamples the grid to a constant orientation object (either \code{\link{trigrid}}, \code{\link{hexagrid}} or \code{\link[terra:rast]{SpatRaster}}). Steps 2-4 are repeated \code{trial} times, and then \code{FUN} is applied to every vector of values that have same spatial position.
}
\examples{
# example to be run if terra is present
if(requireNamespace("terra", quietly=TRUE)){

 # randomly generated points
 x <- rpsphere(100, output="polar")

 # bandwidth grid
 y <- hexagrid(deg=13)

 # output structure
 out <- terra::rast(res=5)

 # the function
 o <- gridensity(x, y, out, trials=7)

 # visualize results
 terra::plot(o)
 points(x, pch=3)
}

}
