% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/labels.R
\docType{methods}
\name{labels<-}
\alias{labels,hyperSpec-method}
\alias{labels<-}
\alias{labels<-,hyperSpec-method}
\title{Get and Set Labels of a hyperSpec Object
\code{value} may be a list or vector of labels giving the new label for
each of the entries specified by \code{which}.}
\usage{
labels (object, which = NULL, ...) <- value

\S4method{labels}{hyperSpec}(object, which = bquote(), drop = TRUE, ...,
  use.colnames = TRUE)
}
\arguments{
\item{object}{a hyperSpec object}

\item{which}{numeric or character to specify the label(s)}

\item{...}{ignored}

\item{value}{the new label(s)}

\item{drop}{if the result would be a list with only one element, should the
element be returned instead?}

\item{use.colnames}{should missing labels be replaced by column names of
the extra data?}
}
\value{
\code{labels<-} returns a \code{hyperSpec} object.

\code{labels} returns a list of labels.  If \code{drop} is
  \code{TRUE} and the list contains only one element, the element is
  returned instead.
}
\description{
The names of the labels are the same as the colnames of the
\code{data.frame}.  The label for the wavelength axis has the name
\code{.wavelength}.
}
\details{
The labels should be given in a form ready for the text-drawing functions
(see \code{\link[grDevices]{plotmath}}), e.g. as \code{expression} or a
\code{character}.
}
\examples{
labels (flu, "c") <- expression ("/" ("c", "mg / l"))
labels (chondro)
}
\author{
C. Beleites
}
\seealso{
\code{\link[base]{labels}}
}

