% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaterLevelDataFrame-methods.R
\name{setTime<-}
\alias{setTime<-}
\alias{setTime<-,WaterLevelDataFrame,ANY-method}
\alias{setTime<--method}
\alias{setTime<-,WaterLevelDataFrame,POSIXct-method}
\alias{setTime<-,WaterLevelDataFrame,POSIXlt-method}
\alias{setTime<-,WaterLevelDataFrame,Date-method}
\title{Set a WaterLevelDataFrame's slot time}
\usage{
setTime(x) <- value

\S4method{setTime}{WaterLevelDataFrame,POSIXct}(x) <- value

\S4method{setTime}{WaterLevelDataFrame,POSIXlt}(x) <- value

\S4method{setTime}{WaterLevelDataFrame,Date}(x) <- value
}
\arguments{
\item{x}{an object of class \linkS4class{WaterLevelDataFrame}.}

\item{value}{a new value of class \code{\link[base:POSIXct]{c("POSIXct", "POSIXt")}}
for the \code{time} slot. \code{value} has to have a length of one and has
to be in the temporal range between \code{1960-01-01 00:00:00 CET} and now
(\code{Sys.time()} or \code{NA}.}
}
\value{
The function above sets a new \code{value} for the slot \code{time} 
  and returns an object of class \linkS4class{WaterLevelDataFrame}. Since
  \code{time} is a slot relevant for the computation of the
  \code{\link[base]{data.frame}} column \code{w}, \code{w} is set to
  \code{NA} and needs to be recomputed by functions like
  \code{\link{waterLevel}} or \code{\link{waterLevelPegelonline}}.
}
\description{
A function to set the slot \code{time} of an object of class
  \linkS4class{WaterLevelDataFrame}.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
setTime(wldf) <- as.POSIXct("2016-12-22")

}
\seealso{
\code{\link{getTime-method}}
}
