% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{label}
\alias{label}
\alias{label<-}
\alias{set_label}
\alias{label.huxtable}
\alias{label<-.huxtable}
\title{Get or Set Table Label}
\usage{
label(ht)
label(ht) <- value
set_label(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A length-one character vector to be used as a table label in LaTeX, or as an ID for the table in HTML. Set to \code{NA} to remove any label.}
}
\value{
For \code{label}, the \code{label} attribute.
For \code{set_label}, the \code{ht} object.
}
\description{
Functions to get or set the table-level table label property of a huxtable.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
label(ht) <-  'tab:mytable'
label(ht)

}
