% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qis}
\alias{qis}
\title{Multidimensional QIS}
\usage{
qis(indices, marginals, skips = 0L)
}
\arguments{
\item{indices}{a List of 1-d arrays specifying the dimension indices of each marginal}

\item{marginals}{a List of arrays containing marginal data. The sum of elements in each array must be identical}

\item{skips}{(optional, default 0) number of Sobol points to skip before sampling}
}
\value{
an object containing:
\itemize{
  \item{a flag indicating if the solution converged}
  \item{the population matrix}
  \item{the exepected state occupancy matrix}
  \item{the total population}
  \item{chi-square and p-value}
}
}
\description{
C++ multidimensional Quasirandom Integer Sampling implementation
}
\examples{
ageByGender = array(c(1,2,5,3,4,3,4,5,1,2), dim=c(5,2))
ethnicityByGender = array(c(4,6,5,6,4,5), dim=c(3,2))
result = qis(list(c(1,2), c(3,2)), list(ageByGender, ethnicityByGender))
}
