% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hkevp.rand.R
\name{hkevp.rand}
\alias{hkevp.rand}
\title{Simulation of the HKEVP}
\usage{
hkevp.rand(nrep, sites, knots, loc, scale, shape, alpha, tau)
}
\arguments{
\item{nrep}{A positive integer.
Number of realisations of the block mashapema process.}

\item{sites}{The coordinates of the sites where the data are observed. Each row corresponds to a site position.}

\item{knots}{The coordinates of the knots in the HKEVP. By default, the positions of the knots coincide with the positions of the sites.}

\item{loc}{A numerical value or a vector of real values for the GEV location parameter. If a vector, its length must coincide with the number of sites. The value by default is 1.}

\item{scale}{A numerical value or a vector of real values for the GEV scale parameter. If a vector, its length must coincide with the number of sites. The value by default is 1.}

\item{shape}{A numerical value or a vector of real values for the GEV shape parameter. If a vector, its length must coincide with the number of sites. The value by default is 1.}

\item{alpha}{The dependence parameter \eqn{\alpha} of the HKEVP: a single value in (0,1].}

\item{tau}{The bandwidth parameter \eqn{\tau} of the kernel functions in the HKEVP: a positive value.}
}
\value{
A numerical matrix of real values.
Each column corresponds to a position and each row to a realisation of the process.
}
\description{
Simulation procedure of the HKEVP with given sites and knots positions and marginal and spatial dependence parameters.
}
\details{
Simulating one realisation of the block mashapema process \eqn{Y(\cdot)} from the HKEVP involves three steps:
\enumerate{
\item The \emph{nugget process} \eqn{U(\cdot)} is generated independently at each position, by simulating a random variable with \eqn{GEV(1,\alpha,\alpha)} distribution.
\item The \emph{residual dependence process} \eqn{\theta(\cdot)} is computed by using the kernel functions centered at the set of knots, the bandwidth parameter \eqn{\tau} and the simulations of the positive stable \eqn{PS(\alpha)} random effect \eqn{A}.
\item The process \eqn{Z = U\theta} is computed and its margins are transformed to the general GEV distribution with \eqn{\mu(s),\sigma(s)} and \eqn{\xi(s)} parameters.
}
}
\examples{
# Simulation of HKEVP:
sites <- as.matrix(expand.grid(1:3,1:3))
loc <- sites[,1]*10
scale <- 3
shape <- 0
alpha <- .4
tau <- 1
ysim <- hkevp.rand(10, sites, sites, loc, scale, shape, alpha, tau)





}
\author{
Quentin Sebille
}
