% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-cur-mhs-data.R
\name{current_medicare_hospital_spending_data}
\alias{current_medicare_hospital_spending_data}
\title{Get Current Medicare Hospital Spending Data.}
\usage{
current_medicare_hospital_spending_data(
  .data,
  .data_sets = c("Claim", "Facility", "State", "National")
)
}
\arguments{
\item{.data}{The data that results from the \code{current_hosp_data()} function.}

\item{.data_sets}{The default is: c("Claim","Facility","State","National"), which will
bring back all of the data in the Medicare Hospital Spending data sets that
are in the file. You can choose from the following:
\itemize{
\item Claim
\item Facility
\item National
\item State
}

You can also pass things like c("state","Nation") as behind the scenes only
the Medicare Hospital Spending data sets are available to the function to choose
from and \code{grep} is used to find matches with \code{ignore.case = TRUE} set.}
}
\value{
Gets the current Medicare Hospital Spending data from the current hospital data file.
}
\description{
Get the current Medicare Hospital Spending data.
}
\details{
This function will obtain the current Medicare Hospital Spending data
from the output of the \code{\link[=current_hosp_data]{current_hosp_data()}} function, that is
the required input for the \code{.data} parameter. You can pass in a list of which
of those data sets you would like,
}
\examples{
\dontrun{
current_hosp_data() |>
  current_maternal_data(.data_sets = c("State","National"))
}

}
\seealso{
\url{https://data.cms.gov/provider-data/topics/hospitals/}

Other Hospital Data: 
\code{\link{current_asc_data}()},
\code{\link{current_asc_oas_cahps_data}()},
\code{\link{current_comp_death_data}()},
\code{\link{current_hai_data}()},
\code{\link{current_hcahps_data}()},
\code{\link{current_hosp_data}()},
\code{\link{current_hvbp_data}()},
\code{\link{current_ipfqr_data}()},
\code{\link{current_maternal_data}()},
\code{\link{current_oqr_oas_cahps_data}()},
\code{\link{current_outpatient_imaging_efficiency_data}()},
\code{\link{current_payments_data}()},
\code{\link{current_pch_hai_hospital_data}()},
\code{\link{current_pch_hcahps_data}()},
\code{\link{current_pch_oncology_measures_hospital_data}()},
\code{\link{current_pch_outcomes_data}()},
\code{\link{current_timely_and_effective_care_data}()},
\code{\link{current_unplanned_hospital_visits_data}},
\code{\link{current_va_data}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Hospital Data}
