% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggpiestats_subtitles.R
\name{subtitle_onesample_proptest}
\alias{subtitle_onesample_proptest}
\title{Making text subtitle for Proportion Test (N Outcomes)}
\usage{
subtitle_onesample_proptest(data, main, counts = NULL, ratio = NULL,
  legend.title = NULL, k = 2, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{main}{The variable to use as the \strong{rows} in the
contingency table.}

\item{counts}{A string naming a variable in data containing counts, or \code{NULL}
if each row represents a single observation (Default).}

\item{ratio}{A vector of numbers: the expected proportions for the proportion
test. Default is \code{NULL}, which means if there are two levels \code{ratio = c(1,1)}, etc.}

\item{legend.title}{Title text for the legend.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{Additional arguments (currently ignored).}
}
\description{
This is going to be a chi-squared Goodness of fit test.
}
\examples{

# with counts
library(jmv)

subtitle_onesample_proptest(
  data = as.data.frame(HairEyeColor),
  main = Eye,
  counts = Freq
)

# in case no variation, only sample size will be shown
subtitle_onesample_proptest(
  data = cbind.data.frame(x = rep("a", 10)),
  main = x
)
}
\author{
Indrajeet Patil
}
