% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{set_config_option}
\alias{set_config_option}
\title{Set GDAL configuration option}
\usage{
set_config_option(key, value)
}
\arguments{
\item{key}{Character name of a configuration option.}

\item{value}{Character value to set for the option.
\code{value = ""} (empty string) will unset a value previously set by
\code{set_config_option()}.}
}
\value{
No return value, called for side effects.
}
\description{
\code{set_config_option()} sets a GDAL runtime configuration option.
Configuration options are essentially global variables the user can set.
They are used to alter the default behavior of certain raster format
drivers, and in some cases the GDAL core. For a full description and
listing of available options see
\url{https://gdal.org/en/stable/user/configoptions.html}.
}
\examples{
set_config_option("GDAL_CACHEMAX", "10\%")
get_config_option("GDAL_CACHEMAX")
## unset:
set_config_option("GDAL_CACHEMAX", "")
}
\seealso{
\code{\link[=get_config_option]{get_config_option()}}

\code{vignette("gdal-config-quick-ref")}
}
