% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{deleteDataset}
\alias{deleteDataset}
\title{Delete named dataset}
\usage{
deleteDataset(filename, format = "")
}
\arguments{
\item{filename}{Filename to delete (should not be open in a \code{GDALRaster}
object).}

\item{format}{Raster format short name (e.g., "GTiff"). If set to empty
string \code{""} (the default), will attempt to guess the raster format from
\code{filename}.}
}
\value{
Logical \code{TRUE} if no error or \code{FALSE} on failure.
}
\description{
\code{deleteDataset()} will attempt to delete the named dataset in a format
specific fashion. Full featured drivers will delete all associated files,
database objects, or whatever is appropriate. The default behavior when no
format specific behavior is provided is to attempt to delete all the files
that would be returned by \code{GDALRaster$getFileList()} on the dataset.
The named dataset should not be open in any existing \code{GDALRaster} objects
when \code{deleteDataset()} is called. Wrapper for \code{GDALDeleteDataset()} in the
GDAL API.
}
\note{
If \code{format} is set to an empty string \code{""} (the default) then the function
will try to identify the driver from \code{filename}. This is done internally in
GDAL by invoking the \code{Identify} method of each registered \code{GDALDriver} in
turn. The first driver that successful identifies the file name will be
returned. An error is raised if a format cannot be determined from the
passed file name.
}
\examples{
b5_file <- system.file("extdata/sr_b5_20200829.tif", package="gdalraster")
b5_tmp <- file.path(tempdir(), "b5_tmp.tif")
file.copy(b5_file,  b5_tmp)

ds <- new(GDALRaster, b5_tmp)
ds$buildOverviews("BILINEAR", levels = c(2, 4, 8), bands = c(1))
files <- ds$getFileList()
print(files)
ds$close()
file.exists(files)
deleteDataset(b5_tmp)
file.exists(files)
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster-class}}, \code{\link[=create]{create()}}, \code{\link[=createCopy]{createCopy()}},
\code{\link[=copyDatasetFiles]{copyDatasetFiles()}}, \code{\link[=renameDataset]{renameDataset()}}
}
