% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_fqa_assessments.R
\name{index_fqa_assessments}
\alias{index_fqa_assessments}
\title{List all available public floristic quality assessments}
\usage{
index_fqa_assessments(database_id, timeout = 4)
}
\arguments{
\item{database_id}{A numeric identifier of the desired database, as specified
by \href{https://universalfqa.org/}{universalfqa.org}. The id numbers can
be viewed with the
\code{\link[=index_fqa_databases]{index_fqa_databases()}} function.}

\item{timeout}{Number of seconds to query UniversalFQA before timing out.}
}
\value{
A data frame with 5 columns:
\itemize{
  \item id (numeric)
  \item assessment (character)
  \item date (date)
  \item site (character)
  \item practitioner (character)
  }
}
\description{
For any given database, \code{index_fqa_assessments()} produces a data frame
of all floristic quality assessments publicly available at
\href{https://universalfqa.org/}{universalfqa.org}.
}
\examples{
\donttest{
databases <- index_fqa_databases() # The 2017 Chicago database has id_number 149
chicago_2017_assessments <- index_fqa_assessments(149)
}

}
