% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.euler.R
\name{plot.euler}
\alias{plot.euler}
\title{Plot Area-Proportional Euler Diagrams}
\usage{
\method{plot}{euler}(x, fill = qualpalr_pal, fill_alpha = 0.4,
  auto.key = FALSE, counts = FALSE, labels = is.logical(auto.key) &&
  !isTRUE(auto.key), fontface = "bold", par.settings = list(), ...,
  default.prepanel = prepanel.euler, default.scales = list(draw = FALSE),
  panel = panel.euler, outer_strips, fill_opacity)
}
\arguments{
\item{x}{An object of class \code{euler}.}

\item{fill}{Fill color. Either a function that takes as its first argument
the number of colors to generate, or a sequence of colors.}

\item{fill_alpha}{Alpha for the fill.}

\item{auto.key}{Plot a legend for the sets.}

\item{counts}{Plot counts.}

\item{labels}{A list or character vector of labels.}

\item{fontface}{Fontface for the labels. (See \code{\link[grid:gpar]{grid::gpar()}}).}

\item{par.settings}{Graphical parameters for trellis displays. See
\code{\link[lattice:trellis.par.get]{lattice::trellis.par.get()}}.}

\item{...}{Arguments to pass down to \code{\link[=panel.euler]{panel.euler()}}, which in turn passes
them down to \code{\link[=panel.euler.circles]{panel.euler.circles()}} and \code{\link[=panel.euler.labels]{panel.euler.labels()}}.}

\item{default.prepanel}{Default prepanel function. Should usually be left
untouched.}

\item{default.scales}{Default scales. Turns off}

\item{panel}{The panel function. Should usually be left untouched.}

\item{outer_strips}{Deprecated}

\item{fill_opacity}{Deprecated}
}
\value{
An object of class \code{"trellis"}. The
  \code{\link[lattice:update.trellis]{update}} method can be used to
  update components of the object and the
  \code{\link[lattice:print.trellis]{print}} method (usually called by
  default) will plot it on an appropriate plotting device.
}
\description{
Plot Euler diagrams with trellis graphics from \pkg{lattice}. This function
calls \code{\link[lattice:xyplot]{lattice::xyplot()}} under the hood, allowing plots of
both individual euler diagrams as well as grids of diagrams
in case the \code{by} argument was used in the call to \code{\link[=euler]{euler()}}.
}
\details{
Almost all of the relevant functionality for \code{\link[lattice:xyplot]{lattice::xyplot()}} is
available here. For instance, providing specifications to
\code{par.settings} will have an effect on many aspects of the plot. Moreover,
arguments that are given here will trickle down to the panel function
\code{\link[=panel.euler]{panel.euler()}} and subsequently to \code{\link[=panel.euler.circles]{panel.euler.circles()}} and
\code{\link[=panel.euler.labels]{panel.euler.labels()}}, which do the actual plotting.

The default value for \code{fill} causes, \pkg{eulerr} to choose color palettes
based on the number of sets, trying to provide palettes adapted to color
vision deficiencies based on \code{\link[qualpalr:qualpal]{qualpalr::qualpal()}}.
}
\examples{
fit <- euler(c("A" = 10, "B" = 5, "A&B" = 3))
plot(fit, labels = c("foo", "bar"), fill_alpha = 0.7)

# Customize colors, remove borders, bump alpha, color labels white
plot(fit,
     fill_alpha = 0.5,
     fill = c("red", "steelblue4"),
     col = "white",
     border = "transparent",
     fontface = "bold.italic")

# Add counts to the plot
plot(fit, counts = TRUE)

# Add a custom legend and retain counts
plot(fit, counts = TRUE, auto.key = list(space = "bottom", columns = 2))

# Plot without fills and distinguish sets with border types instead
plot(fit, lty = c("solid", "dotted"), fill = "transparent", cex = 2,
     fontface = 2, labels = c("foo", "bar"))

# Plot a grid of euler plots
dat <- data.frame(
  A      = sample(c(TRUE, FALSE), size = 100, replace = TRUE),
  B      = sample(c(TRUE, TRUE, FALSE), size = 100, replace = TRUE),
  gender = sample(c("Men", "Women"), size = 100, replace = TRUE),
  nation = sample(c("Sweden", "Denmark"), size = 100, replace = TRUE)
)

gridfit <- euler(dat[, 1:2], by = dat[, 3:4])
plot(gridfit, auto.key = TRUE)

# We can modify the grid layout as well
plot(gridfit, layout = c(1, 4))
}
\seealso{
\code{\link[=panel.euler.circles]{panel.euler.circles()}}, \code{\link[=panel.euler.labels]{panel.euler.labels()}},
\code{\link[lattice:xyplot]{lattice::xyplot()}}, \code{\link[grid:gpar]{grid::gpar()}}, \code{\link[grid:grid.circle]{grid::grid.circle()}},
\code{\link[lattice:panel.xyplot]{lattice::panel.xyplot()}}, \code{\link[=euler]{euler()}}, \code{\link[qualpalr:qualpal]{qualpalr::qualpal()}}
}
