% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sir.R
\name{sirmod}
\alias{sirmod}
\title{Gradient-function for the SIR model}
\usage{
sirmod(t, y, parameters)
}
\arguments{
\item{t}{Implicit argument for time}

\item{y}{A vector with initial values for the states}

\item{parameters}{A vector with parameter values for the SIR system}
}
\value{
A list of gradients
}
\description{
Gradient-function for the SIR model
}
\examples{
require(deSolve)
times  = seq(0, 26, by=1/10)
paras  = c(mu = 0, N = 1, beta =  2, gamma = 1/2)
start = c(S=0.999, I=0.001, R = 0)
out=ode(start, times, sirmod, paras)
}
