% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_estimation.R
\name{get_estimation_ratio}
\alias{get_estimation_ratio}
\title{This function allows you to estimate ratio variables at universe level.}
\usage{
get_estimation_ratio(
  data = ech::toy_ech_2018,
  variable.x = NULL,
  variable.y = NULL,
  by.x = NULL,
  by.y = NULL,
  domain = NULL,
  level = NULL,
  ids = NULL,
  numero = "numero",
  estrato = NULL,
  pesoano = "pesoano",
  name = "estimacion"
)
}
\arguments{
\item{data}{data frame with ECH microdata}

\item{variable.x}{data frame column to estimate}

\item{variable.y}{data frame column to estimate}

\item{by.x}{data frame column}

\item{by.y}{data frame column}

\item{domain}{subpopulation reference setted as character expresion of logical evaluation}

\item{level}{is household ("h") or individual ("i")}

\item{ids}{Variable name of cluster}

\item{numero}{Variable name of household id}

\item{estrato}{Variable name of strata}

\item{pesoano}{Variable name of weights}

\item{name}{name for the estimation new column}
}
\value{
table
}
\description{
This function allows you to estimate ratio variables at universe level.
}
\details{
Disclaimer: This script is not an official INE product.
Aviso: El script no es un producto oficial de INE.
}
\examples{
\donttest{
toy_ech_2018 <- employment(data = ech::toy_ech_2018, pobpcoac = "pobpcoac")
get_estimation_ratio(data = toy_ech_2018, variable.x = "po", variable.y = "pea", level = "i")
}
}
\seealso{
Other estimation: 
\code{\link{get_estimation_gini}()},
\code{\link{get_estimation_gpg}()},
\code{\link{get_estimation_mean}()},
\code{\link{get_estimation_median}()},
\code{\link{get_estimation_qsr}()},
\code{\link{get_estimation_total}()},
\code{\link{set_design}()}
}
\concept{estimation}
\keyword{inference}
