% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SystemMetadata.R
\docType{methods}
\name{initialize,SystemMetadata-method}
\alias{SystemMetadata-initialize}
\alias{initialize,SystemMetadata-method}
\title{Initialize a DataONE SystemMetadata object with default values or values passed in to the constructor.}
\usage{
\S4method{initialize}{SystemMetadata}(.Object, identifier = as.character(NA),
  formatId = as.character(NA), size = as.numeric(NA),
  checksum = as.character(NA), checksumAlgorithm = "SHA-1",
  submitter = as.character(NA), rightsHolder = as.character(NA),
  accessPolicy = data.frame(subject = character(), permission = character()),
  replicationAllowed = TRUE, numberReplicas = 3,
  obsoletes = as.character(NA), obsoletedBy = as.character(NA),
  archived = FALSE, dateUploaded = as.character(NA),
  dateSysMetadataModified = as.character(NA),
  originMemberNode = as.character(NA),
  authoritativeMemberNode = as.character(NA), preferredNodes = list(),
  blockedNodes = list(), seriesId = as.character(NA),
  mediaType = as.character(NA), fileName = as.character(NA))
}
\arguments{
\item{.Object}{The object being initialized}

\item{identifier}{value of type \code{"character"}, the identifier of the object that this system metadata describes.}

\item{formatId}{value of type \code{"character"}, the DataONE object format for the object.}

\item{size}{value of type \code{"numeric"}, the size of the object in bytes.}

\item{checksum}{value of type \code{"character"}, the checksum for the object using the designated checksum algorithm.}

\item{checksumAlgorithm}{value of type \code{"character"}, the name of the hash function used to generate a checksum, from the DataONE controlled list.}

\item{submitter}{value of type \code{"character"}, the Distinguished Name or identifier of the person submitting the object.}

\item{rightsHolder}{value of type \code{"character"}, the Distinguished Name or identifier of the person who holds access rights to the object.}

\item{accessPolicy}{value of type \code{"data.frame"} containing (subject, permission) tuples to constitute the access authorization rules.}

\item{replicationAllowed}{value of type \code{"logical"}, for replication policy allows replicants.}

\item{numberReplicas}{value of type \code{"numeric"}, for number of supported replicas.}

\item{obsoletes}{value of type \code{"character"}, the identifier of an object which this object replaces.}

\item{obsoletedBy}{value of type \code{"character"}, the identifier of an object that replaces this object.}

\item{archived}{value of type \code{"logical"}, a boolean flag indicating whether the object has been archived and thus hidden.}

\item{dateUploaded}{value of type \code{"character"}, the date on which the object was uploaded to a member node.}

\item{dateSysMetadataModified}{value of type \code{"character"}, the last date on which this system metadata was modified.}

\item{originMemberNode}{value of type \code{"character"}, the node identifier of the node on which the object was originally registered.}

\item{authoritativeMemberNode}{value of type \code{"character"}, the node identifier of the node which currently is authoritative for the object.}

\item{preferredNodes}{list of \code{"character"}, each of which is the node identifier for a node to which a replica should be sent.}

\item{blockedNodes}{list of \code{"character"}, each of which is the node identifier for a node blocked from housing replicas.}

\item{seriesId}{value of type \code{"character"}, a unique Unicode string that identifies an object revision chain. A seriesId will resolve to the latest version of an object.}

\item{mediaType}{value of type \code{"character"}, the IANA Media Type (aka MIME-Type) of the object, e.g. "text/csv".}

\item{fileName}{value of type \code{"character"}, a suggested file name for the object (if the object containing this sysmeta is serialized).}
}
\value{
the SystemMetadata instance representing an object
}
\description{
Initialize a SystemMetadata object by providing default values for core information 
needed to manage objects across repository systems. SystemMetadata contains basic identification, ownership,
access policy, replication policy, and related metadata.
}
\seealso{
\url{http://mule1.dataone.org/ArchitectureDocs-current/apis/Types.html#Types.SystemMetadata}

\code{\link{SystemMetadata-class}}
}

