% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.taglength.r
\name{gl.filter.taglength}
\alias{gl.filter.taglength}
\title{Filters loci in a genlight \{adegenet\} object based on sequence tag
 length
 @family matched filter}
\usage{
gl.filter.taglength(x, lower = 20, upper = 69, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{lower}{Lower threshold value below which loci will be removed
[default 20].}

\item{upper}{Upper threshold value above which loci will be removed
[default 69].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
Returns a genlight object retaining loci with a sequence tag length
in the range specified by the lower and upper threshold.
}
\description{
SNP datasets generated by DArT typically have sequence tag lengths ranging
from 20 to 69 base pairs.
}
\examples{
 \donttest{
# SNP data
  gl.report.taglength(testset.gl)
  result <- gl.filter.taglength(testset.gl,lower=60)
  gl.report.taglength(result)
# Tag P/A data
  gl.report.taglength(testset.gs)
  result <- gl.filter.taglength(testset.gs,lower=60)
  gl.report.taglength(result)
  }
  test <- gl.subsample.loci(platypus.gl, n =100)
  res <- gl.report.taglength(test)
  
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
