% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{content_list_with_permissions}
\alias{content_list_with_permissions}
\alias{content_list_guid_has_access}
\title{Get Content List with Permissions}
\usage{
content_list_with_permissions(src, ..., .p = NULL)

content_list_guid_has_access(content_list, guid)
}
\arguments{
\item{src}{A Connect R6 object}

\item{...}{Extra arguments. Currently not used}

\item{.p}{Optional. A predicate function, passed as-is to \code{purrr::keep()}. See
\code{get_content()} for more details. Can greatly help performance by reducing
how many items to get permissions for}

\item{content_list}{A "content list with permissions" as returned by \code{content_list_with_permissions()}}

\item{guid}{A user or group GUID to filter the content list by whether they have access}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} These functions are experimental placeholders until the API supports
this behavior.
}
\details{
\code{content_list_with_permissions} loops through content and retrieves
permissions for each item (with a progress bar). This can take a long time
for lots of content! Make sure to use the optional \code{.p} argument as a predicate
function that filters the content list before it is transformed.

\code{content_list_guid_has_access} works with a \code{content_list_with_permissions}
dataset by checking whether a given GUID (either user or group) has access to
the content by:
\itemize{
\item checking if the content has access_type == "all"
\item checking if the content has access_type == "logged_in"
\item checking if the provided guid is the content owner
\item checking if the provided guid is in the list of content permissions (in the "permissions" column)
}
}
