% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancensus.R
\name{list_census_datasets}
\alias{list_census_datasets}
\title{Query the CensusMapper API for available datasets.}
\usage{
list_census_datasets(use_cache = TRUE, quiet = FALSE)
}
\arguments{
\item{use_cache}{If set to TRUE (the default), data will be read from a temporary local cache for the
duration of the R session, if
available. If set to FALSE, query the API for the data, and
refresh the temporary cache with the result.}

\item{quiet}{When TRUE, suppress messages and warnings.}
}
\value{
Returns a data frame with a column \code{dataset} containing the code for the
dataset, a column \code{description} describing it, a \code{geo_dataset} column
identifying the geography dataset the data is based on, a \code{attribution} column
with an attribution string, a \code{reference} column with a reference identifier, and
a \code{reference_url} column with a link to reference materials.
}
\description{
Query the CensusMapper API for available datasets.
}
\examples{

# List available datasets in CensusMapper
list_census_datasets()
}
