% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps.R
\name{bls_map_state}
\alias{bls_map_state}
\title{Cloropleth mapping of BLS data.}
\usage{
bls_map_state(map_data, fill_rate, labtitle = NULL)
}
\arguments{
\item{map_data}{Dataframe to be used as the map's measures. Usually a result of 
function calls format_county_data or format_state_data, but other dataframes, 
which include FIPS codes may be used as well.}

\item{fill_rate}{Column name from the dataframe that you want to use as a fill value.}

\item{labtitle}{The main title label for your map passed as a string. The default is no title}
}
\description{
Return a ggplot object to render a cloropleth map with state outlines.
#' The map files contain 2015 FIPS codes and can be used with any data set containing
county and state FIPS codes. They can not be used with Leaflet but the original 
shapefiles can be downloaded at \url{https://www.census.gov/geo/maps-data/data/cbf/cbf_state.html}
for analysis which requires more customized mapping.
}
\examples{
\dontrun{
# Downlaod employment statistics for April 2016.
df <- get_bls_state("April 2016", seasonality = TRUE)

# Map the unemployment rate from data set.
bls_gg <- bls_map_state(map_data = df, fill_rate = "unemployed_rate", 
             labtitle = "Unemployment Rate")
bls_gg
}



}
\keyword{api}
\keyword{bls}
\keyword{economics}
\keyword{geo}
\keyword{geography}
\keyword{map}
\keyword{unemployment}

