% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_clock_models.R
\name{init_rln_clock_model}
\alias{init_rln_clock_model}
\title{Initializes a Relaxed Log-Normal clock model}
\usage{
init_rln_clock_model(rln_clock_model, distr_id = 0, param_id = 0)
}
\arguments{
\item{rln_clock_model}{a Relaxed Log-Normal clock model,
as returned by \code{\link{create_rln_clock_model}}}

\item{distr_id}{a distributions' ID}

\item{param_id}{a parameter's ID}
}
\value{
an initialized Relaxed Log-Normal clock model
}
\description{
Initializes a Relaxed Log-Normal clock model
}
\examples{
check_empty_beautier_folder()

rln_clock_model <- create_rln_clock_model()
# FALSE: not yet initialized
is_init_rln_clock_model(rln_clock_model)
rln_clock_model <- init_rln_clock_model(rln_clock_model)
# Dimension is set to NA by default, for unknown reasons.
# Because 'init_rln_clock_model' does not initialize it (for
# unknown reasons), set it manually
rln_clock_model$dimension <- 42
# TRUE: now it is initialized
is_init_rln_clock_model(rln_clock_model)

check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
