% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_param.R
\name{create_s_param}
\alias{create_s_param}
\alias{create_param_s}
\title{Create a parameter called s}
\usage{
create_s_param(id = NA, value = 0, lower = 0, upper = Inf)
}
\arguments{
\item{id}{the parameter's ID}

\item{value}{value of the parameter}

\item{lower}{lowest possible value of the parameter. If the parameter
is estimated, \code{lower} must be less than \code{value}}

\item{upper}{upper value of the parameter}
}
\value{
a parameter called s
}
\description{
Create a parameter called s
}
\note{
this parameter is used in a log-normal distribution
  (as returned by \code{\link{create_log_normal_distr}})
}
\examples{
if (is_on_ci()) {

  # Create the parameter
  s_param <- create_s_param()

  # Use the parameter in a distribution
  log_normal_distr <- create_log_normal_distr(
    s = s_param
  )

  # Use the distribution to create a BEAST2 input file
  beast2_input_file <- get_beautier_tempfilename()
  create_beast2_input_file(
    input_filename = get_fasta_filename(),
    beast2_input_file,
    tree_prior = create_yule_tree_prior(
      birth_rate_distr = log_normal_distr
    )
  )
  file.remove(beast2_input_file)

  remove_beautier_folder()
}
}
\seealso{
the function \code{\link{create_param}} contains a list
  of all parameters that can be created
}
\author{
Richèl J.C. Bilderbeek
}
