% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Joins.R
\name{JoinTables}
\alias{JoinTables}
\alias{ajoin}
\alias{ijoin}
\alias{ljoin}
\alias{ojoin}
\alias{rjoin}
\alias{sjoin}
\alias{ujoin}
\title{Inner, Left, Right, Outer, Semi and Anti Join for Data Tables}
\usage{
ijoin(x, y, by = NULL)

ljoin(x, y, by = NULL)

rjoin(x, y, by = NULL)

ojoin(x, y, by = NULL)

sjoin(x, y, by = NULL)

ajoin(x, y, by = NULL)

ujoin(x, y, all.y = FALSE, by = NULL)
}
\arguments{
\item{x}{[\code{\link{data.frame}}]\cr
First data.frame to join.}

\item{y}{[\code{\link{data.frame}}]\cr
Second data.frame to join.}

\item{by}{[\code{character}]\cr
Column name(s) of variables used to match rows in \code{x} and \code{y}.
If not provided, a heuristic similar to the one described in the \pkg{dplyr} vignette is used:
\enumerate{
  \item If \code{x} is keyed, the existing key will be used if \code{y} has the same column(s).
  \item If \code{x} is not keyed, the intersect of common columns names is used if not empty.
  \item Raise an exception.
}
You may pass a named character vector to merge on columns with different names in \code{x} and
\code{y}: \code{by = c("x.id" = "y.id")} will match \code{x}'s \dQuote{x.id} column with \code{y}\'s
\dQuote{y.id} column.}

\item{all.y}{[logical(1)]\cr
Keep columns of \code{y} which are not in \code{x}?}
}
\value{
[\code{\link{data.table}}] with key identical to \code{by}.
}
\description{
These helper functions perform join operations on data tables.
Most of them are basically one-liners.
See \url{http://rpubs.com/ronasta/join_data_tables} for a overview of join operations in
data table or alternatively \pkg{dplyr}'s vignette on two table verbs.
}
\examples{
# Create two tables for demonstration
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
batchMap(identity, x = 1:6, reg = tmp)
x = getJobPars(reg = tmp)
y = findJobs(x >= 2 & x <= 5, reg = tmp)
y$extra.col = head(letters, nrow(y))

# Inner join: similar to intersect(): keep all columns of x and y with common matches
ijoin(x, y)

# Left join: use all ids from x, keep all columns of x and y
ljoin(x, y)

# Right join: use all ids from y, keep all columns of x and y
rjoin(x, y)

# Outer join: similar to union(): keep all columns of x and y with matches in x or y
ojoin(x, y)

# Semi join: filter x with matches in y
sjoin(x, y)

# Anti join: filter x with matches not in y
ajoin(x, y)

# Updating join: Replace values in x with values in y
ujoin(x, y)
}

