\name{awstindex}
\alias{awstindex}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Tail index estimation }
\description{
  The function finds a pareto-approximation of the tail of a univariate 
  distribution and estimates the parameter in this pareto-approximation.
  The construction is similar to the Hill-estimator. The number of
  largest observations used in the estimate is chosen adaptively.
}
\usage{
awstindex(y, qlambda = NULL, eta = 0.5, lkern = "Triangle", hinit = 1, 
          hincr = 1.25, hmax = 1000, graph = FALSE, symmetric = FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{y}{ \code{y} contains the observed values at location \code{x}. 
           In case of \code{x=NULL} (second parameter) \code{y} is assumed to be 
           observed on a one, two or three-dimensional grid. The dimension of 
           \code{y} determines if one, two or three-dimensional AWS is used.}
  \item{qlambda}{ \code{qlambda} determines the scale parameter \code{qlambda} 
           for the stochastic penalty. The scaling parameter in the stochastic 
           penalty \code{lambda} is choosen as the \code{qlambda}-quantile
           of a Chi-square-distribution with number of parameters in the polynomial 
           model as degrees of freedom. If \code{qlambda=NULL} a standard value 
           depending on \code{model} and \code{symmetric} is choosen. }
  \item{eta}{ \code{eta} is a memory parameter used to stabilize the procedure. 
           \code{eta}  has to be between \code{0} and \code{1}, with 
           \code{eta=.5} being the default. }
  \item{lkern}{ \code{lkern} determines the location kernel to be used. Options 
           are \code{"Uniform"}, \code{"Triangle"}, \code{"Quadratic"}, 
           \code{"Cubic"} and \code{"Exponential"}. Default is \code{"Triangle"}. 
           The Kernel operates on the squared distance, so \code{"Triangle"}
           corresponds to the use of an Epanechnikov kernel in kernel smoothing. 
           \code{"Exponential"} requires larger values of \code{hmax} and 
           therefore more iterations to reach comparable results. }
  \item{hinit}{ \code{hinit} Initial bandwidth for the location penalty. 
           Appropriate value is choosen in case of \code{hinit==NULL}  }
  \item{hincr}{ \code{hincr} \code{hincr^(1/d)}, with \code{d} the 
           dimensionality of the design, is used as a factor to increase the 
           bandwidth between iterations. Defauts to \code{hincr=1.2}}   
  \item{hmax}{ \code{hmax} Maximal bandwidth to be used. Determines the 
           number of iterations and is used as the stopping rule. }
  \item{graph}{ \code{graph} if \code{TRUE} results are displayed after each 
           iteration step. }
  \item{symmetric}{ If \code{symmetric==TRUE} the stochastic penalty is
           symmetrized, i.e. \code{(sij + sji)/lambda} is used instead of 
           \code{sij/lambda}. See references for details.}

}
\details{
  From the data \code{y} an descending order statistics \code{yn <- order(y)[n:1]} is computed 
  and transformed observations \code{x <- (1:(n-1))*yn[-n]/yn[-1]} are defined. The transformed
  observations are assumed to follow an inhomogenious exponential model. Adaptive Weights Smoothing,
  i.e. function \code{\link{laws}} with parameter \code{model="Exponential"}, is used 
  to construct an inhomogenious intensity estimate. The estimated tail index is the estimated
  intensity in the left-most point, corresponding to the largest observation in the sample.
  This estimate is similar to the Hill-estimate computed from the \code{k} largest observations
  with \code{k} approximately equal to the sum of weights used for estimating the tail index
  by AWS. See Section 8 in Polzehl and Spokoiny (2002) for details.
  
  }
\value{ The returned object is a list with components
  \item{tindex }{Estimated tail-index}
  \item{intensity }{Estimates of the intensity in the exponential model}
  \item{y }{Values of \code{y}}
  \item{call }{actual function call}
}
\references{ 
\item{ }{    Polzehl, J. and Spokoiny, V. (2002). 
\emph{Local likelihood modelling by adaptive weights smoothing}, 
WIAS-Preprint 787} 
\item{ }{ 
     Polzehl, J. and Spokoiny, V. (2000). \emph{Adaptive Weights Smoothing
     with applications to image restoration}, J.R.Statist.Soc. B, 62,
     Part 2, pp.335-354
 }
 }
\author{ Joerg Polzehl, \email{polzehl@wias-berlin.de }}


\seealso{ SEE ALSO \code{\link{aws}}, \code{\link{laws}} }

\examples{
###
###   Estimate the tail-index of a cauchy distribution
###   absolute values can be used because of the symmetry of centered cauchy
###
set.seed(1)
n <- 500
x <- rcauchy(n)
tmp <- awstindex(abs(x),hmax=n)
tmp$tindex
###
###   now show the segmentation generated by AWS 
###
plot(tmp$intensity[1:250],type="l")
}
\keyword{ smooth }% at least one, from doc/KEYWORDS
\keyword{ nonparametric }% at least one, from doc/KEYWORDS
\keyword{ models }% __ONLY ONE__ keyword per line
