% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipc-stream.R
\name{write_ipc_stream}
\alias{write_ipc_stream}
\title{Write Arrow IPC stream format}
\usage{
write_ipc_stream(x, sink, ...)
}
\arguments{
\item{x}{\code{data.frame}, \link{RecordBatch}, or \link{Table}}

\item{sink}{A string file path, connection, URI, or \link{OutputStream}, or path in a file
system (\code{SubTreeFileSystem})}

\item{...}{extra parameters passed to \code{write_feather()}.}
}
\value{
\code{x}, invisibly.
}
\description{
Apache Arrow defines two formats for \href{https://arrow.apache.org/docs/format/Columnar.html#serialization-and-interprocess-communication-ipc}{serializing data for interprocess communication (IPC)}:
a "stream" format and a "file" format, known as Feather. \code{write_ipc_stream()}
and \code{\link[=write_feather]{write_feather()}} write those formats, respectively.
}
\examples{
tf <- tempfile()
on.exit(unlink(tf))
write_ipc_stream(mtcars, tf)
}
\seealso{
\code{\link[=write_feather]{write_feather()}} for writing IPC files. \code{\link[=write_to_raw]{write_to_raw()}} to
serialize data to a buffer.
\link{RecordBatchWriter} for a lower-level interface.
}
