% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anim.plots.R
\name{anim.barplot}
\alias{anim.barplot}
\alias{anim.barplot.default}
\title{Create an animated barplot.}
\usage{
anim.barplot(...)

\method{anim.barplot}{default}(height, times = NULL, show = TRUE,
  speed = 1, use.times = TRUE, window = t, window.process = NULL,
  width = 1, space = NULL, names.arg = NULL, beside = FALSE,
  density = NULL, angle = NULL, col = NULL, border = NULL,
  horiz = FALSE, xlim = NULL, ylim = NULL, xlab = NULL,
  ylab = NULL, main = NULL, sub = NULL, offset = NULL,
  legend.text = NULL, ...)
}
\arguments{
\item{height}{a vector, matrix or array. If a vector it is divided up by 
\code{times} and \code{\link{barplot}} is called on each chunk. If a
matrix, \code{\link{barplot}} is called on each column. If an array, 
\code{\link{barplot}} is called on each matrix of form \code{height[,,i]}.}

\item{times}{a vector of times. If NULL and \code{height} is a matrix,
the last dimension of \code{height} will be used}

\item{show, speed, use.times, window, window.process}{see \code{\link{anim.plot}}}

\item{width, space, beside, names.arg, density, angle, col, border, horiz, xlim, ylim, xlab, ylab, main, sub, offset, legend.text, ...}{arguments passed to \code{\link{barplot}}.}
}
\description{
Create an animated barplot.
}
\details{
Arguments \code{width, names.arg, density, angle, col, border} 
and \code{offset} may be either vectors
of length \code{length(tbl)} or matrices with one column for each unique 
value of \code{times}. Other arguments should be length 1 or vectors.
}
\examples{
anim.barplot(1:100, times=rep(1:10, each=10), ylim=c(0,100))
## barplot with a matrix
ChickWeight$wq <- cut(ChickWeight$weight, 5)
tbl <- as.array(xtabs(~ wq + Diet + Time, data=ChickWeight))
ptbl <- prop.table(tbl, 2:3)
anim.barplot(ptbl, xlab="Diet", ylab="N", xlim=c(0,8), legend.text=paste(
     "Quintile", 1:5), col=1:5)
anim.barplot(tbl, xlab="Diet", ylab="N", beside=TRUE, ylim=c(0,20),
   legend.text=paste("Quintile", 1:5), col=1:5)
   
}
