% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_nlcd}
\alias{process_nlcd}
\title{Process land cover data}
\usage{
process_nlcd(path = NULL, year = 2021, extent = NULL, ...)
}
\arguments{
\item{path}{character giving nlcd data path}

\item{year}{numeric giving the year of NLCD data used}

\item{extent}{numeric(4) or SpatExtent giving the extent of the raster
if \code{NULL} (default), the entire raster is loaded}

\item{...}{Placeholders.}
}
\value{
a \code{SpatRaster} object
}
\description{
The \code{process_nlcd()} function imports and cleans raw land cover data,
returning a single \code{SpatRaster} object.

Reads NLCD file of selected \code{year}.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
nlcd <- process_nlcd(
  path = "./data/",
  year = 2021
)
}
}
\author{
Eva Marques, Insang Song
}
