% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_nei}
\alias{process_nei}
\title{Process road emissions data}
\usage{
process_nei(path = NULL, county = NULL, year = c(2017, 2020), ...)
}
\arguments{
\item{path}{character(1). Directory with NEI csv files.}

\item{county}{\code{SpatVector}/\code{sf}. County boundaries.}

\item{year}{integer(1) Year to use. Currently only 2017 or 2020
is accepted.}

\item{...}{Placeholders.}
}
\value{
a \code{SpatVector} object
}
\description{
The \code{process_nei()} function imports and cleans raw road emissions data,
returning a single \code{SpatVector} object.

NEI data comprises multiple csv files where emissions of
50+ pollutants are recorded at county level. With raw data files,
this function will join a combined table of NEI data and county
boundary, then perform a spatial join to target locations.
}
\note{
Base files for \code{county} argument can be downloaded directly from
\href{https://www.census.gov/geographies/mapping-files/time-series/geo/tiger-line-file.html}{U.S. Census Bureau}
or by using \code{tigris} package. This function does not reproject census boundaries.
Users should be aware of the coordinate system of census boundary data for
other analyses.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
nei <- process_nei(
  path = "./data",
  county = system.file("gpkg/nc.gpkg", package = "sf"),
  year = 2017
)
}
}
\author{
Insang Song
}
