% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_modis_merge}
\alias{process_modis_merge}
\title{Process MODIS .hdf files}
\usage{
process_modis_merge(
  path = NULL,
  date = NULL,
  subdataset = NULL,
  fun_agg = "mean",
  ...
)
}
\arguments{
\item{path}{character. Full list of hdf file paths.
preferably a recursive search result from \code{\link[base:list.files]{base::list.files}}.}

\item{date}{character(1). date to query. Should be in
\code{"YYYY-MM-DD"} format.}

\item{subdataset}{character(1). subdataset names to extract.
Should conform to regular expression. See \code{\link[base:regex]{base::regex}} for details.
Default is \code{NULL}, which will result in errors. Users should specify
which subdatasets will be imported.}

\item{fun_agg}{Function name or custom function to aggregate overlapping
cell values. See \code{fun} description in \code{\link[terra:tapp]{terra::tapp}} for details.}

\item{...}{For internal use.}
}
\value{
a \code{SpatRaster} object
}
\description{
Get mosaicked or merged raster from multiple MODIS hdf files.
}
\note{
Curvilinear products (i.e., swaths) will not be accepted.
MODIS products downloaded by functions in \code{amadeus},
\href{https://cran.r-project.org/package=MODISTools}{MODISTools},
and \href{https://github.com/rspatial/luna}{luna} are accepted.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
mod09ga_merge <- process_modis_merge(
  path =
    list.files("./data", pattern = "MOD09GA.", full.names = TRUE),
  date = "2024-01-01",
  subdataset = "sur_refl_b01_1",
  fun_agg = "mean"
)
}
}
\seealso{
\code{\link{download_data}}
}
\author{
Insang Song
}
