% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{EVPool}
\alias{EVPool}
\title{Extreme value plot for pooling groups}
\usage{
EVPool(
  x,
  AMAX = NULL,
  gauged = FALSE,
  dist = "GenLog",
  QMED = NULL,
  Title = "Pooled growth curve",
  UrbAdj = FALSE,
  CDs
)
}
\arguments{
\item{x}{pooling group derived from the Pool() function}

\item{AMAX}{the AMAX sample to be plotted in the case of gauged. If NULL, & gauged equals TRUE, the AMAX from the first site in the pooling group is used}

\item{gauged}{logical argument with a default of FALSE. If FALSE, the plot is the ungauged pooled curve accompanied by the single site curves of the group members. If TRUE, the plot is the gauged curve and single site curve with the observed points added}

\item{dist}{a choice of distribution. Choices are "GEV", "GenLog", "Kappa3", or "Gumbel". The default is "GenLog"}

\item{QMED}{a chosen QMED to convert the curve from a growth curve to the frequency curve}

\item{Title}{a character string. The user chosen plot title. The default is "Pooled growth curve"}

\item{UrbAdj}{a logical argument with a default of FALSE. If TRUE and urban adjustment is applied to the pooled growth curve}

\item{CDs}{catchment descriptors derived from either GetCDs or CDsXML. Only necessary if UrbAdj is TRUE}
}
\value{
An extreme value plot for gauged or ungauged pooling groups
}
\description{
Plots the extreme value frequency curve or growth curve for gauged or ungauged pooled groups
}
\examples{
#Get some CDs, form an ungauged pooling group and apply EVPlot.
CDs.28015 <- GetCDs(28015)
Pool.28015 <- Pool(CDs.28015, exclude = 28015)
EVPool(Pool.28015)
#Do the same for the gauged case, change the title, and convert with a QMED of 105.5.
PoolG.28015 <- Pool(CDs.28015)
EVPool(PoolG.28015, gauged = TRUE, Title = "Gauged frequency curve - Site 28015", QMED = 9.8)
#Pretend we have an extra AMAX for the gauge. Amend the pooling group Lcv and LSkew
#for the site accordingly then apply EVPool with the updated AMAX.
#Firstly, get the AMAX sample
AM.28015 <- GetAM(28015)
#Add an extra AMAX flow of 15m3/s
Append28015 <- append(AM.28015$Flow, 15)
#Amend the Lcv and Lskew in the pooling group
PoolG.28015[1, c(16, 17)] <- c(Lcv(Append28015), LSkew(Append28015))
#Now plot gauged with the updated AMAX
EVPool(PoolG.28015, AMAX = Append28015, gauged = TRUE)
}
\author{
Anthony Hammond
}
