% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BFslope.R
\name{BayesFactorSlope}
\alias{BayesFactorSlope}
\title{Bayes Factor for Slope Parameters in Latent-Trait MPT}
\usage{
BayesFactorSlope(fittedModel, parameter, direction = "<", plot = TRUE, ...)
}
\arguments{
\item{fittedModel}{a fitted latent-trait model with predictor variables that have
been defined via \code{predStructure}.}

\item{parameter}{name of the slope parameter (e.g., \code{"slope_d_covariate"})}

\item{direction}{alternative hypothesis: whether slope is smaller or larger
than zero (\code{"<"} or \code{">"}) or unequal to zero (\code{"!="})}

\item{plot}{if \code{TRUE}, the prior and posterior densities and the ratio at slope=0 are plotted.}

\item{...}{further arguments passed to \code{\link[logspline]{logspline}}, which is used to
approximate the density of the posterior distribution.}
}
\description{
Uses the Savage-Dickey method to compute the Bayes factor that the slope
parameter of a continuous covariate is zero vs. positive/negative/unequal to zero.
}
\examples{
\dontrun{
# fit beta-MPT model for encoding condition (see ?arnold2013):
EQNfile <- system.file("MPTmodels/2htsm.eqn", package="TreeBUGS")

d.encoding <- subset(arnold2013, group == "encoding", select = -(1:4))
d.cov <- subset(arnold2013, group == "encoding", select = "age")
fit <- traitMPT(EQNfile, d.encoding, n.thin=5,
                restrictions=list("D1=D2=D3","d1=d2","a=g"),
                covData = d.cov, predStructure = list("D1 ; age"))
# convergence
plot(fit, parameter = "slope", type = "default")
summary(fit)
BayesFactorSlope(fit, "slope_D1_age", direction = "<")
}
}
