% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WilcoxonAnalyze.R
\name{Wilcoxon_analyze}
\alias{Wilcoxon_analyze}
\title{Differential Gene Expression Analysis Using Wilcoxon Rank-Sum Test}
\usage{
Wilcoxon_analyze(
  tumor_file,
  normal_file,
  output_file,
  logFC_threshold = 2.5,
  fdr_threshold = 0.05
)
}
\arguments{
\item{tumor_file}{Path to the tumor data file (RDS format).}

\item{normal_file}{Path to the normal data file (RDS format).}

\item{output_file}{Path to save the output DEG data (RDS format).}

\item{logFC_threshold}{Threshold for log fold change for marking up/down-regulated genes.}

\item{fdr_threshold}{Threshold for FDR for filtering significant genes.}
}
\value{
A data frame of differential expression results.
}
\description{
This function performs differential gene expression analysis using Wilcoxon rank-sum tests.
It reads tumor and normal expression data, performs TMM normalization using 'edgeR', and uses Wilcoxon rank-sum tests to identify differentially expressed genes.
}
\examples{
# Define file paths for tumor and normal data from the data folder
tumor_file <- system.file("extdata",
                          "removebatch_SKCM_Skin_TCGA_exp_tumor_test.rds",
                          package = "TransProR")
normal_file <- system.file("extdata",
                           "removebatch_SKCM_Skin_Normal_TCGA_GTEX_count_test.rds",
                           package = "TransProR")
output_file <- file.path(tempdir(), "Wilcoxon_rank_sum_testoutRst.rds")

# Run the Wilcoxon rank sum test
outRst <- Wilcoxon_analyze(
  tumor_file = tumor_file,
  normal_file = normal_file,
  output_file = output_file,
  logFC_threshold = 2.5,
  fdr_threshold = 0.01
)

# View the top 5 rows of the result
head(outRst, 5)
}
\references{
Li, Y., Ge, X., Peng, F., Li, W., & Li, J. J. (2022). Exaggerated False Positives by Popular
Differential Expression Methods When Analyzing Human Population Samples. Genome Biology, 23(1), 79.
DOI: https://doi.org/10.1186/s13059-022-02648-4.
}
