% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routines.R
\name{estimatepopulation.0}
\alias{estimatepopulation.0}
\title{Estimate the total population including the dark figure.
 If the user wishes to find bootstrap confidence intervals then the routine \code{\link{estimatepopulation}} should be used instead.}
\usage{
estimatepopulation.0(zdat, method = "stepwise", quantiles = c(0.025,
  0.975), mX = NULL, pthresh = 0.02)
}
\arguments{
\item{zdat}{Data matrix with \eqn{t+1} columns. The first \eqn{t} columns, each corresponding to a particular list,
are 0s and 1s defining the capture histories
observed. The last column is the count of cases with that particular capture history.
List names A, B, ... are constructed if not supplied. Where a capture history is not explicitly listed,
it is assumed that it has zero count.}

\item{method}{If \code{method = "stepwise"} the stepwise method implemented in \code{\link{stepwisefit}} is used.  If \code{method = "fixed"} then a specified fixed model is used; the model is then given by \code{mX}.  If \code{method = "main"} then main effects only are fitted.}

\item{quantiles}{Quantiles of interest for confidence intervals.}

\item{mX}{A \eqn{2 \times k} matrix giving the \eqn{k} two-list parameters to be included in the model if \code{method = "fixed"}.
Each column of \code{mX} contains the numbers of the corresponding pair of lists.
If \code{mX = 0}, then all two-list parameters are included. If \code{mX = NULL}, no two-list parameters are included and
 the main effects model is fitted.
If only one two-list parameter is to be fitted, it is sufficient to specify it as a vector of length 2, e.g \code{mX=c(1,3)}
for the parameter indexed by lists 1 and 3.   If \code{method} is equal to \code{"stepwise"} or \code{"main"}, then \code{mX} is ignored.}

\item{pthresh}{Threshold p-value used if \code{method = "stepwise"}.}
}
\value{
A list with components as below

\code{estimate} Point estimate and confidence interval estimates corresponding to specified quantiles.

\code{MSEfit} The model fitted to the data in the format described in \code{\link{modelfit}}.
}
\description{
This routine estimates the total population size, which includes the dark figure, together with confidence intervals as specified.
It also returns the details of the fitted model.  The user can choose whether to fit main effects only,
to fit a particular model containing specified two-list parameters, or
to choose the model using the stepwise approach described by Chan, Silverman and Vincent (2019).
}
\examples{
data(NewOrl)
data(NewOrl_5)
estimatepopulation.0(NewOrl, method="stepwise", quantiles=c(0.025,0.975))
estimatepopulation.0(NewOrl_5, method="main", quantiles=c(0.01, 0.05,0.95, 0.99))

}
\references{
Chan, L., Silverman, B. W., and Vincent, K. (2019).
 Multiple Systems Estimation for Sparse Capture Data: Inferential Challenges when there are Non-Overlapping Lists.
  Available from \url{https://arxiv.org/abs/1902.05156}.
}
