% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forEasySdcTable.R
\encoding{UTF8}
\name{FindDimLists}
\alias{FindDimLists}
\title{Finding dimList}
\usage{
FindDimLists(x, groupVarInd = HierarchicalGroups(x = x), addName = FALSE,
  sep = ".", xReturn = FALSE, total = "Total")
}
\arguments{
\item{x}{Matrix or data frame containing the variables (micro data or cell counts data).}

\item{groupVarInd}{List of vectors of indices defining the hierarchical variable groups.}

\item{addName}{When TRUE the variable name is added to the level names, except for variables with most levels.}

\item{sep}{A character string to separate when addName apply.}

\item{xReturn}{When TRUE x is also in output, possibly changed according to addName.}

\item{total}{String used to name totals.}
}
\value{
Output is a list according to the specifications in sdcTable.
        When xReturn is TRUE output has an extra list level and x is the first element.
}
\description{
Finding lists of level-hierarchy as needed for the input parameter
dimList to the function makeProblem in package sdcTable
}
\examples{
 x <- rep(c('A','B','C'),3)
 y <- rep(c(11,22,11),3)
 z <- c(1,1,1,2,2,2,3,3,3)
 zy <- paste(z,y,sep='')
 m <- cbind(x,y,z,zy)
 FindDimLists(m)
}
