% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIXTCOMP_methods.R
\name{summary.MixtComp}
\alias{summary.MixtComp}
\title{MixtComp Object Summaries}
\usage{
\method{summary}{MixtComp}(object, ...)
}
\arguments{
\item{object}{\emph{MixtComp} object}

\item{...}{Not used.}
}
\description{
Summary of a \emph{MixtComp} object
}
\examples{
require(RMixtCompIO) # for learning a mixture model
dataLearn <- list(var1 = as.character(c(rnorm(50, -2, 0.8), rnorm(50, 2, 0.8))),
                  var2 = as.character(c(rnorm(50, 2), rpois(50, 8))))
                  
model <- list(var1 = list(type = "Gaussian", paramStr = ""),
              var2 = list(type = "Poisson", paramStr = ""))

algo <- list(
  nClass = 2,
  nInd = 100,
  nbBurnInIter = 100,
  nbIter = 100,
  nbGibbsBurnInIter = 100,
  nbGibbsIter = 100,
  nInitPerClass = 3,
  nSemTry = 20,
  confidenceLevel = 0.95,
  ratioStableCriterion = 0.95,
  nStableCriterion = 10,
  mode = "learn"
)

resLearn <- rmcMultiRun(algo, dataLearn, model, nRun = 3)

summary(resLearn)

}
\seealso{
\code{mixtCompLearn} \code{\link{print.MixtComp}}
}
\author{
Quentin Grimonprez
}
