% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GLmix.R
\name{GLmix}
\alias{GLmix}
\title{Kiefer-Wolfowitz NPMLE for Gaussian Location Mixtures}
\usage{
GLmix(x, v = 300, sigma = 1, hist = FALSE, histm = 300,
  weights = NULL, ...)
}
\arguments{
\item{x}{Data: Sample Observations}

\item{v}{Undata: Grid Values defaults equal spacing of with v bins, when v is
a scalar}

\item{sigma}{scale parameter of the Gaussian noise, may take vector values
of length(x)}

\item{hist}{If TRUE then aggregate x to histogram bins, when sigma is vector
valued this option is inappropriate unless there are only a small number of
distinct sigma values.}

\item{histm}{histogram bin boundaries, equally spacing with \code{histm}
bins when  scalar.}

\item{weights}{replicate weights for x obervations, should sum to 1}

\item{...}{other parameters to pass to KWDual to control optimization}
}
\value{
An object of class density with components:
	\item{x}{points of  evaluation on the domain of the density}
	\item{y}{estimated function values at the points v, the mixing density}
	\item{g}{the estimated mixture density function values at x}
	\item{logLik}{Log likelihood value at the proposed solution}
	\item{dy}{prediction of mean parameters for each observed x value via Bayes Rule}
	\item{status}{exit code from the optimizer}
}
\description{
Kiefer Wolfowitz Nonparametric MLE for Gaussian Location Mixtures
}
\details{
Kiefer Wolfowitz MLE as proposed by Jiang and Zhang for
the Gaussian compound decision problem.  The histogram option is intended
for large problems, say n > 1000, where reducing the sample size dimension
is desirable. When \code{sigma} is heterogeneous and \code{hist = TRUE} the
procedure tries to do separate histogram binning for distinct values of
\code{sigma}, however this is only feasible when there are only a small
number of distinct \code{sigma}. By default the grid for the binning is
equally spaced on the support of the data. This function does the normal
convolution problem, for gamma mixtures of variances see \code{GVmix}, or
for mixtures of both means and variances \code{TLVmix}.

The predict method for \code{GLmix} objects will compute means, medians or
modes of the posterior according to whether the \code{Loss} argument is 2, 1
or 0.
}
\author{
Roger Koenker
}
\references{
Kiefer, J. and J. Wolfowitz Consistency of the Maximum
Likelihood Estimator in the Presence of Infinitely Many Incidental
Parameters \emph{Ann. Math. Statist}.  Volume 27, Number 4 (1956), 887-906.

Jiang, Wenhua and Cun-Hui Zhang General maximum likelihood empirical Bayes
estimation of normal means \emph{Ann. Statist.}, Volume 37, Number 4 (2009),
1647-1684.

Koenker, R and I. Mizera, (2014) ``Convex Optimization, Shape Constraints,
Compound Decisions, and Empirical Bayes Rules,'' \emph{JASA}, 109, 674--685.
}
\keyword{nonparametric}

