% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Bmix.R
\name{Bmix}
\alias{Bmix}
\title{Binomial mixture estimation via Kiefer Wolfowitz MLE}
\usage{
Bmix(x, k, v = 300, collapse = TRUE, weights = NULL, ...)
}
\arguments{
\item{x}{Count of "successes" for binomial observations}

\item{k}{Number of trials for binomial observations}

\item{v}{Grid Values for the mixing distribution defaults to equal
spacing of length v on [eps, 1- eps], if v is scalar.}

\item{collapse}{Collapse observations into cell counts.}

\item{weights}{replicate weights for x obervations, should sum to 1}

\item{...}{Other arguments to be passed to KWDual to control optimization}
}
\value{
An object of class density with components:
	\item{x}{grid midpoints of evaluation of the mixing density}
	\item{y}{function values of the mixing density at x}
	\item{g}{estimates of the mixture density at the distinct data values}
	\item{logLik}{Log Likelihood value at the estimate}
	\item{dy}{Bayes rule estimates of binomial probabilities for distinct data values}
	\item{status}{exit code from the optimizer}
}
\description{
Interior point solution of Kiefer-Wolfowitz NPMLE for mixture of binomials
}
\author{
R. Koenker
}
\references{
Kiefer, J. and J. Wolfowitz Consistency of the Maximum
Likelihood Estimator in the Presence of Infinitely Many Incidental
Parameters \emph{Ann. Math. Statist}. 27, (1956), 887-906.

Koenker, R and I. Mizera, (2014) ``Convex Optimization, Shape Constraints,
Compound Decisions, and Empirical Bayes Rules,'' \emph{JASA}, 109, 674--685.
}
\keyword{nonparametric}

