% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/05PTSample.r
\docType{methods}
\name{write.sample}
\alias{write.sample}
\alias{write.sample,PTSample,character-method}
\title{Write a PTSample object to an audio file}
\usage{
\S4method{write.sample}{PTSample,character}(sample, filename, what = c("wav",
  "8svx", "raw"))
}
\arguments{
\item{sample}{A \code{PTSample} object that needs to be exported to an audio
file.}

\item{filename}{A \code{character} string representing the filename to which
the audio needs to be saved.}

\item{what}{A \code{character} string indicating what type of file is to be
exported. Can be one of the following: "\code{wav}" (default),
"\code{8svx}" or "\code{raw}".}
}
\value{
Saves the audio to a file, but returns nothing.
}
\description{
Write a \code{PTSample} as a "wav", "8svx" or "raw" audio file.
}
\details{
This method provides a wrapper for the \code{\link[tuneR]{writeWave}} method
from \code{\link[tuneR]{tuneR}}. It also provides the means to export audio
to file formats native to the Commodore Amiga. \code{PTSample}s can be
exported as simple (uncompressed) \href{https://en.wikipedia.org/wiki/8SVX}{8svx}
files also known as "iff" files). In addition they can be exported as raw data,
where each byte simply represented a signed integer value of the waveform.
}
\examples{
\dontrun{
data("mod.intro")

## Export the second sample of mod.intro as a wav file:
write.sample(PTSample(mod.intro, 2), "snaredrum.wav", "wav")

## Export the second sample of mod.intro as an 8svx file:
write.sample(PTSample(mod.intro, 2), "snaredrum.iff", "8svx")

## Export the second sample of mod.intro as a raw file:
write.sample(PTSample(mod.intro, 2), "snaredrum.raw", "raw")
}
}
\author{
Pepijn de Vries
}
\seealso{
Other io.operations: \code{\link{read.module}},
  \code{\link{read.module,ANY-method}},
  \code{\link{read.module,character-method}};
  \code{\link{read.sample}},
  \code{\link{read.sample,character-method}};
  \code{\link{write.module}},
  \code{\link{write.module,PTModule,ANY-method}},
  \code{\link{write.module,PTModule,character-method}}

Other sample.operations: \code{\link{PTSample,PTModule,numeric-method}},
  \code{\link{PTSample,Wave,missing-method}},
  \code{\link{PTSample,raw,missing-method}},
  \code{\link{PTSample-method}}, \code{\link{PTSample<-}},
  \code{\link{PTSample<-,PTModule,numeric,PTSample-method}};
  \code{\link{PTSample}}, \code{\link{PTSample-class}};
  \code{\link{fineTune}},
  \code{\link{fineTune,PTSample-method}},
  \code{\link{fineTune<-}},
  \code{\link{fineTune<-,PTSample,numeric-method}};
  \code{\link{loopLength}},
  \code{\link{loopLength,PTSample-method}},
  \code{\link{loopLength<-}},
  \code{\link{loopLength<-,PTSample-method}};
  \code{\link{loopSample}},
  \code{\link{loopSample,PTSample-method}};
  \code{\link{loopStart}},
  \code{\link{loopStart,PTSample-method}},
  \code{\link{loopStart<-}},
  \code{\link{loopStart<-,PTSample-method}};
  \code{\link{loopState}},
  \code{\link{loopState,PTSample-method}};
  \code{\link{name}}, \code{\link{name,PTModule-method}},
  \code{\link{name,PTSample-method}}, \code{\link{name<-}},
  \code{\link{name<-,PTModule,character-method}},
  \code{\link{name<-,PTSample,character-method}};
  \code{\link{playSample}},
  \code{\link{playSample,PTModule-method}},
  \code{\link{playSample,PTSample-method}};
  \code{\link{read.sample}},
  \code{\link{read.sample,character-method}};
  \code{\link{sampleLength}},
  \code{\link{sampleLength,PTSample-method}};
  \code{\link{volume}},
  \code{\link{volume,PTSample-method}},
  \code{\link{volume<-}},
  \code{\link{volume<-,PTSample,numeric-method}};
  \code{\link{waveform}},
  \code{\link{waveform,PTSample-method}},
  \code{\link{waveform<-}},
  \code{\link{waveform<-,PTSample-method}}
}

