% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/09playing_routines.r
\docType{methods}
\name{playMod}
\alias{playMod}
\alias{playMod,PTModule-method}
\title{Play PTModule objects}
\usage{
\S4method{playMod}{PTModule}(mod, wait = T, ...)
}
\arguments{
\item{mod}{A \code{\link{PTModule}} object to be played.}

\item{wait}{A \code{logical} value. When set to \code{TRUE} the playing
routine will wait with executing any code until the playing is
finished. When set to \code{FALSE}, subsequent R code will be
executed while playing.}

\item{...}{Arguments that are passed on to \code{\link{modToWave}}.}
}
\value{
A \code{\link[tuneR]{Wave}} object, generated from the
\code{mod} object, is returned.
}
\description{
Converts \code{\link{PTModule}} objects into audio
\code{\link[tuneR]{Wave}}s, and plays them.
}
\details{
Unfortunately, it was not feasible to create a routine that can directly
interpret \code{\link{PTModule}} objects and play them simultaneously.
Instead, the audio first needs to be rendered after which it can be played.
This method therefore first calls \code{\link{modToWave}} and then
\code{\link{playWave}}. Rendering may take some time and requires some
balance between speed, quality and accuracy. See the documentation of the
\code{\link{modToWave}} method for the control you have on these aspects.
}
\examples{
\dontrun{
data("mod.intro")

## play the module and capture the audio Wave
wav <- playMod(mod.intro)
}
}
\author{
Pepijn de Vries
}
\seealso{
Other module.operations: \code{\link{PTModule}},
  \code{\link{PTModule-class}};
  \code{\link{appendPattern}},
  \code{\link{appendPattern,PTModule,PTPattern-method}};
  \code{\link{clearSamples}},
  \code{\link{clearSamples,PTModule-method}};
  \code{\link{clearSong}},
  \code{\link{clearSong,PTModule-method}};
  \code{\link{deletePattern}},
  \code{\link{deletePattern,PTModule,numeric-method}};
  \code{\link{modToWave}},
  \code{\link{modToWave,PTModule-method}};
  \code{\link{moduleSize}},
  \code{\link{moduleSize,PTModule-method}};
  \code{\link{patternLength}},
  \code{\link{patternLength,PTModule-method}};
  \code{\link{patternOrderLength}},
  \code{\link{patternOrderLength,PTModule-method}},
  \code{\link{patternOrderLength<-}},
  \code{\link{patternOrderLength<-,PTModule,numeric-method}};
  \code{\link{patternOrder}},
  \code{\link{patternOrder,PTModule-method}},
  \code{\link{patternOrder<-}},
  \code{\link{patternOrder<-,PTModule,ANY,numeric-method}};
  \code{\link{playingtable}},
  \code{\link{playingtable,PTModule-method}};
  \code{\link{read.module}},
  \code{\link{read.module,ANY-method}},
  \code{\link{read.module,character-method}};
  \code{\link{trackerFlag}},
  \code{\link{trackerFlag,PTModule-method}},
  \code{\link{trackerFlag<-}},
  \code{\link{trackerFlag<-,PTModule-method}};
  \code{\link{write.module}},
  \code{\link{write.module,PTModule,ANY-method}},
  \code{\link{write.module,PTModule,character-method}}

Other play.audio.routines: \code{\link{playSample}},
  \code{\link{playSample,PTModule-method}},
  \code{\link{playSample,PTSample-method}};
  \code{\link{playWave}},
  \code{\link{playWave,Wave-method}}
}

