% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{clearSong}
\alias{clearSong}
\alias{clearSong,PTModule-method}
\title{Clear all pattern info from module}
\usage{
\S4method{clearSong}{PTModule}(mod)
}
\arguments{
\item{mod}{A \code{\link{PTModule}} object from which all pattern (order)
info needs to be removed.}
}
\value{
Returns a copy of of object \code{mod} in which all pattern (order)
info is removed.
}
\description{
Remove all patterns (\code{\link{PTPattern}}) and \code{\link{patternOrder}}
info from a \code{\link{PTModule}} object.
}
\details{
Conform the original ProTracker, this method removes all patterns
(\code{\link{PTPattern}}) and \code{\link{patternOrder}}
info from a module. You keep the audio \code{\link{PTSample}}s.
}
\examples{
data(mod.intro)

## 'clear.mod' is a copy of 'mod.intro' without the
## pattern (order) info. It still has the audio samples.
clear.mod <- clearSong(mod.intro)
}
\author{
Pepijn de Vries
}
\seealso{
Other module.operations: \code{\link{PTModule}},
  \code{\link{PTModule-class}};
  \code{\link{appendPattern}},
  \code{\link{appendPattern,PTModule,PTPattern-method}};
  \code{\link{clearSamples}},
  \code{\link{clearSamples,PTModule-method}};
  \code{\link{deletePattern}},
  \code{\link{deletePattern,PTModule,numeric-method}};
  \code{\link{modToWave}},
  \code{\link{modToWave,PTModule-method}};
  \code{\link{moduleSize}},
  \code{\link{moduleSize,PTModule-method}};
  \code{\link{patternLength}},
  \code{\link{patternLength,PTModule-method}};
  \code{\link{patternOrderLength}},
  \code{\link{patternOrderLength,PTModule-method}},
  \code{\link{patternOrderLength<-}},
  \code{\link{patternOrderLength<-,PTModule,numeric-method}};
  \code{\link{patternOrder}},
  \code{\link{patternOrder,PTModule-method}},
  \code{\link{patternOrder<-}},
  \code{\link{patternOrder<-,PTModule,ANY,numeric-method}};
  \code{\link{playMod}},
  \code{\link{playMod,PTModule-method}};
  \code{\link{playingtable}},
  \code{\link{playingtable,PTModule-method}};
  \code{\link{read.module}},
  \code{\link{read.module,ANY-method}},
  \code{\link{read.module,character-method}};
  \code{\link{trackerFlag}},
  \code{\link{trackerFlag,PTModule-method}},
  \code{\link{trackerFlag<-}},
  \code{\link{trackerFlag<-,PTModule-method}};
  \code{\link{write.module}},
  \code{\link{write.module,PTModule,ANY-method}},
  \code{\link{write.module,PTModule,character-method}}
}

