% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mobius.R
\name{crossRatio}
\alias{crossRatio}
\title{Cross ratio}
\usage{
crossRatio(A, B, C, D)
}
\arguments{
\item{A, B, C, D}{four distinct points}
}
\value{
A complex number. It is real if and only if the four points lie on
  a generalized circle (that is a circle or a line).
}
\description{
The cross ratio of four points.
}
\examples{
c <- Circle$new(c(0, 0), 1)
A <- c$pointFromAngle(0)
B <- c$pointFromAngle(90)
C <- c$pointFromAngle(180)
D <- c$pointFromAngle(270)
crossRatio(A, B, C, D) # should be real
Mob <- Mobius$new(rbind(c(1+1i,2),c(0,3-2i)))
MA <- Mob$transform(A)
MB <- Mob$transform(B)
MC <- Mob$transform(C)
MD <- Mob$transform(D)
crossRatio(MA, MB, MC, MD) # should be identical to `crossRatio(A, B, C, D)`
}
