% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SklearnToJson.R
\name{sklearnToJson}
\alias{sklearnToJson}
\title{Saves sklearn python model object to json in path}
\usage{
sklearnToJson(model, path)
}
\arguments{
\item{model}{a fitted sklearn python model object}

\item{path}{path to the saved model file}
}
\value{
nothing, saves the model to the path as json
}
\description{
Saves sklearn python model object to json in path
}
\examples{
\dontshow{ # dontrun reason: requires python environment with sklearn }
\dontrun{ 
sklearn <- reticulate::import("sklearn", convert = FALSE)
model <- sklearn$tree$DecisionTreeClassifier()
model$fit(sklearn$datasets$load_iris()$data, sklearn$datasets$load_iris()$target)
saveLoc <- file.path(tempdir(), "model.json")
sklearnToJson(model, saveLoc)
# the model.json is saved in the tempdir
dir(tempdir())
# clean up
unlink(saveLoc)
}
}
