% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sollis2009_Unit_Root.R
\name{Sollis2009_Unit_Root}
\alias{Sollis2009_Unit_Root}
\title{Sollis(2009) nonlinear unit root test function}
\usage{
Sollis2009_Unit_Root(x, case, lags, lsm)
}
\arguments{
\item{x}{series name,}

\item{case}{if raw data 1 if demeaned data 2 if detrended data 3,}

\item{lags}{maximum lag}

\item{lsm}{lag selection methods if 1 AIC, if 2 BIC, if 3 t-stat significance}
}
\value{
"Model" Estimated model

"Selected lag" the lag order

"Test Statistic" the value of the test statistic
}
\description{
This function allows you to make Sollis(2009) nonlinear unit root test
}
\examples{
x <- rnorm(1000)
Sollis2009_Unit_Root(x, case = 1, lags = 6, lsm = 3)


y <- cumsum(rnorm(1000))
Sollis2009_Unit_Root(y, 3, 8, 1)


data(IBM)
Sollis2009_Unit_Root(IBM,case = 2,lags = 12,lsm = 2)


}
\references{
Sollis, R. (2009). A simple unit root test against asymmetric STAR nonlinearity with an application to real exchange rates in Nordic countries. Economic modelling, 26(1), 118-125.

Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{nonlinear}
\keyword{root}
\keyword{test}
\keyword{unit}
