% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KSS_Unit_Root.R
\name{KSS_Unit_Root}
\alias{KSS_Unit_Root}
\title{Kapetanios, Shin and Snell(2003) nonlinear unit root test function}
\usage{
KSS_Unit_Root(x, case, lags, lsm)
}
\arguments{
\item{x}{series name,}

\item{case}{if raw data 1 if demeaned data 2 if detrended data 3,}

\item{lags}{maximum lag}

\item{lsm}{lag selection methods if 1 AIC, if 2 BIC, if 3 t-stat significance}
}
\value{
"Model" Estimated model

"Selected lag" the lag order

"Test Statistic" the value of the test statistic
}
\description{
This function allows you to make Kapetanios, Shin and Snell(2003) nonlinear unit root test
}
\examples{

x <- rnorm(1000)
KSS_Unit_Root(x, case = 1, lags = 6, lsm =1)


y <- cumsum(rnorm(1000))
KSS_Unit_Root(y, 1, 3, 3)


data(IBM)
KSS_Unit_Root(IBM,case = 1,lags = 20,lsm = 3)


}
\references{
Kapetanios, G., Shin, Y., & Snell, A. (2003). Testing for a unit root in the nonlinear STAR framework. Journal of econometrics, 112(2), 359-379.


Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{nonlinear}
\keyword{root}
\keyword{test}
\keyword{unit}
