% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mape.R
\name{mape}
\alias{mape}
\title{Mean absolute percentage error}
\usage{
mape(actual, predicted, w = NULL, clip_small = 0, ...)
}
\arguments{
\item{actual}{Observed values.}

\item{predicted}{Predicted values.}

\item{w}{Optional case weights.}

\item{clip_small}{Minimal absolute value in the denominator. Used to avoid divisions by 0.}

\item{...}{Further arguments passed to \code{weighted_mean}.}
}
\value{
A numeric vector of length one.
}
\description{
Weighted mean absolute percentage error of predicted values.
}
\examples{
mape(1:10, (1:10)^2)
mape(1:10, (1:10)^2, w = rep(1, 10))
mape(1:10, (1:10)^2, w = 1:10)
}
\author{
Michael Mayer, \email{mayermichael79@gmail.com}
}
