% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{parse_CI_string}
\alias{parse_CI_string}
\title{Parse a string with point estimate and confidence interval}
\usage{
parse_CI_string(string, sep = ",")
}
\arguments{
\item{string}{A vector of strings to be parsed.}

\item{sep}{The character (not including whitespaces) separating the lower from the upper limits.}
}
\description{
Given a vector of strings such as "0.65 (0.6, 0.70)", for example obtained by running optical character recognition (OCR)
software on a screenshot of a published forest plot, parses the strings into a dataframe of
point estimates and upper confidence interval limits. Assumes that the point estimate occurs before
an opening bracket of the form "(" or "[" and that the confidence interval upper limit follows a
the character \code{sep} (by default a comma, but might be a hyphen, for example). To further parse this dataframe
into point estimates and variances, see \code{MetaUtility::scrape_meta}.
}
\examples{
# messy string of confidence intervals
mystring = c( "0.65 [0.6, 0.7]", "0.8(0.5, 0.9]", "1.2  [0.3, 1.5)")
parse_CI_string(mystring)

# now with a hyphen separator
mystring = c( "0.65 [0.6- 0.7]", "0.8(0.5 - 0.9]", "1.2  [0.3 -1.5)")
parse_CI_string(mystring, sep="-")
}
