% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{format_stat}
\alias{format_stat}
\title{Manuscript-friendly number formatting}
\usage{
format_stat(x, digits = 2, cutoffs = c(0.01, 10^-5))
}
\arguments{
\item{x}{Numeric value to format}

\item{digits}{Digits for rounding}

\item{cutoffs}{A vector containing the two cutoffs}
}
\description{
Formats a numeric result (e.g., p-value) as a manuscript-friendly string in which values below a minimum cutoff (e.g., 10^-5) are
reported for example as "< 10^-5", values between the minimum cutoff and a maximum cutoff (e.g., 0.01)
are reported in scientific notation, and p-values above the maximum cutoff are reported simply as, for example, 0.72.
}
\examples{
format_stat(0.735253)
format_stat(0.735253, digits = 4)
format_stat(0.0123)
format_stat(0.0001626)
format_stat(0.0001626, cutoffs = c(0.01, 10^-3))
}
