% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans.R
\name{t_shallow}
\alias{t_shallow}
\alias{t_deep}
\alias{t,RsparseMatrix-method}
\alias{t,CsparseMatrix-method}
\alias{t,TsparseMatrix-method}
\alias{t,dgCMatrix-method}
\alias{t,ngCMatrix-method}
\alias{t,lgCMatrix-method}
\alias{t,dtCMatrix-method}
\alias{t,ntCMatrix-method}
\alias{t,ltCMatrix-method}
\alias{t,dsCMatrix-method}
\alias{t,nsCMatrix-method}
\alias{t,lsCMatrix-method}
\alias{t,sparseVector-method}
\title{Transpose a sparse matrix by changing its format}
\usage{
t_shallow(x)

t_deep(x)

\S4method{t}{RsparseMatrix}(x)

\S4method{t}{CsparseMatrix}(x)

\S4method{t}{TsparseMatrix}(x)

\S4method{t}{dgCMatrix}(x)

\S4method{t}{ngCMatrix}(x)

\S4method{t}{lgCMatrix}(x)

\S4method{t}{dtCMatrix}(x)

\S4method{t}{ntCMatrix}(x)

\S4method{t}{ltCMatrix}(x)

\S4method{t}{dsCMatrix}(x)

\S4method{t}{nsCMatrix}(x)

\S4method{t}{lsCMatrix}(x)

\S4method{t}{sparseVector}(x)
}
\arguments{
\item{x}{A sparse matrix. If `x` is of a different type, will just invoke its generic
`t()` method.}
}
\value{
The transpose of `x` (rows become columns and columns become rows),
but in the opposite format (CSC -> CSR, CSR -> CSC); or the same format if calling `t_deep`.
}
\description{
Transposes a sparse matrix in CSC (a.k.a. "CsparseMatrix")
or CSR (a.k.a. "RsparseMatrix") formats by converting it to the opposite format
(i.e. CSC -> CSR, CSR -> CSC).

This implies only a shallow copy (i.e. it's much faster), as the only necessary thing to make
such transpose operation is to swap the number of rows and columns and change the class
of the object (all data remains the same), avoiding any deep copying and
format conversion as when e.g. creating a CSC transpose of a CSC matrix.

If the input is neither a CSR not CSC matrix, it will just call the generic `t()` method.

Also provided is a function `t_deep` which outputs a transpose with the same storage order.
}
\details{
\bold{Important:} When loading this package (`library(MatrixExtra)`), it will
change the behavior of `t(sparseMatrix)` towards calling `t_shallow`.

This makes it more efficient, but has the potential of breaking existing code in other
packages, particularly in the `Matrix` package itself when calling some arbitrary
function or method which would internally transpose a CSC matrix and rely on the assumption
that its output is also CSC.

This behavior can be changed through \link{restore_old_matrix_behavior} or
the package options (e.g. `options("MatrixExtra.fast_transpose" = FALSE)` -
ee \link{MatrixExtra-options}) to have `t_deep` as the default, just like in `Matrix`.

Additionally, under the new behavior (`t_shallow` as the default for `t`),
transposing a `sparseVector` object will yield a CSR matrix ("RsparseMatrix"),
which differs from `Matrix` that would yield a COO matrix ("TsparseMatrix").
}
\examples{
library(Matrix)
library(MatrixExtra)
set.seed(1)
X <- rsparsematrix(3, 4, .5, repr="C")
inherits(X, "CsparseMatrix")
Xtrans <- t_shallow(X)
inherits(Xtrans, "RsparseMatrix")
nrow(X) == ncol(Xtrans)
ncol(X) == nrow(Xtrans)

Xorig <- t_shallow(Xtrans)
inherits(Xorig, "CsparseMatrix")
inherits(t_deep(Xtrans), "RsparseMatrix")

### Important!!!
### This package makes 't_shallow' the default
set_new_matrix_behavior()
inherits(X, "CsparseMatrix")
inherits(t(X), "RsparseMatrix")

### Can be changed back to 't_deep' like this:
restore_old_matrix_behavior()
inherits(t(X), "CsparseMatrix")
}
